(function($$1) {
    'use strict';

    $$1 = `default` in $$1 ? $$1.default : $$1;

    var initialPageStr = ``;
    var initialTotalStr = ``;

    var FilterMenu = (function() {
        function FilterMenu(target, th, column, index, options) {
            this.options = options;
            this.th = th;
            this.column = column;
            this.index = index;
            // 2023-04-19 saito chg
            // this.tds = target.find('tbody tr td:nth-child(' + (this.column + 1) + ')').toArray();
            // 2023-07-11 son chg
            // this.tds = target.find(`tbody tr td:nth-child(` + (this.column + 1) + `) .sheet-sort-value`).toArray();
            this.tds = target.find(`> tbody > tr > td:nth-child(` + (this.column + 1) + `) > .sheet-sort-value`).toArray();
        }
        FilterMenu.prototype.initialize = function() {
            this.menu = this.dropdownFilterDropdown();
            this.th.appendChild(this.menu);
            var $trigger = jQuery(this.menu.children[0]);
            var $content = jQuery(this.menu.children[1]);
            var $menu = jQuery(this.menu);
            $trigger.click(function() {
                return $content.toggle();
            });
            jQuery(document).click(function(el) {
                if (!$menu.is(el.target) && $menu.has(el.target).length === 0) {
                    $content.hide();
                }
            });
        };
        FilterMenu.prototype.searchToggle = function(value) {
            if (this.selectAllCheckbox instanceof HTMLInputElement) {this.selectAllCheckbox.checked = false;}
            if (value.length === 0) {
                this.toggleAll(true);
                if (this.selectAllCheckbox instanceof HTMLInputElement) {this.selectAllCheckbox.checked = true;}
                return;
            }
            this.toggleAll(false);
            this.inputs.filter(function(input) {
                return input.value.toLowerCase().indexOf(value.toLowerCase()) > -1;
            }).forEach(function(input) {
                input.checked = true;
            });
        };
        FilterMenu.prototype.updateSelectAll = function() {
            if (this.selectAllCheckbox instanceof HTMLInputElement) {
                jQuery(this.searchFilter).val(``);
                this.selectAllCheckbox.checked = this.inputs.length === this.inputs.filter(function(input) {
                    return input.checked;
                }).length;
            }
        };
        FilterMenu.prototype.selectAllUpdate = function(checked) {
            jQuery(this.searchFilter).val(``);
            this.toggleAll(checked);
        };
        FilterMenu.prototype.toggleAll = function(checked) {
            for (var i = 0; i < this.inputs.length; i++) {
                var input = this.inputs[i];
                if (input instanceof HTMLInputElement) {input.checked = checked;}
            }
        };
        FilterMenu.prototype.dropdownFilterItem = function(td, self) {
            var value = td.innerText;
            var dropdownFilterItem = document.createElement(`div`);
            dropdownFilterItem.className = `dropdown-filter-item`;
            var input = document.createElement(`input`);
            input.type = `checkbox`;
            input.value = value.trim().replace(/ +(?= )/g, ``);
            input.setAttribute(`checked`, `checked`);
            input.className = `dropdown-filter-menu-item item`;
            input.setAttribute(`data-column`, self.column.toString());
            input.setAttribute(`data-index`, self.index.toString());
            dropdownFilterItem.appendChild(input);
            // 2023-08-10 son chg
            // dropdownFilterItem.innerHTML = dropdownFilterItem.innerHTML.trim() + ` ` + value;
            dropdownFilterItem.innerHTML = dropdownFilterItem.innerHTML.trim() + ` ` + escape_html(value);
            return dropdownFilterItem;
        };
        FilterMenu.prototype.dropdownFilterItemSelectAll = function() {
            var value = this.options.captions.select_all;
            var dropdownFilterItemSelectAll = document.createElement(`div`);
            dropdownFilterItemSelectAll.className = `dropdown-filter-item`;
            var input = document.createElement(`input`);
            input.type = `checkbox`;
            input.value = this.options.captions.select_all;
            input.setAttribute(`checked`, `checked`);
            input.className = `dropdown-filter-menu-item select-all`;
            input.setAttribute(`data-column`, this.column.toString());
            input.setAttribute(`data-index`, this.index.toString());
            dropdownFilterItemSelectAll.appendChild(input);
            dropdownFilterItemSelectAll.innerHTML = dropdownFilterItemSelectAll.innerHTML + ` ` + value;
            return dropdownFilterItemSelectAll;
        };
        FilterMenu.prototype.dropdownFilterSearch = function() {
            var dropdownFilterItem = document.createElement(`div`);
            dropdownFilterItem.className = `dropdown-filter-search`;
            var input = document.createElement(`input`);
            input.type = `text`;
            input.className = `dropdown-filter-menu-search form-control`;
            input.setAttribute(`data-column`, this.column.toString());
            input.setAttribute(`data-index`, this.index.toString());
            input.setAttribute(`placeholder`, this.options.captions.search);
            dropdownFilterItem.appendChild(input);
            return dropdownFilterItem;
        };
        FilterMenu.prototype.dropdownFilterSort = function(direction) {
            var dropdownFilterItem = document.createElement(`div`);
            dropdownFilterItem.className = `dropdown-filter-sort`;
            var span = document.createElement(`span`);
            span.className = direction.toLowerCase().split(` `).join(`-`);
            span.setAttribute(`data-column`, this.column.toString());
            span.setAttribute(`data-index`, this.index.toString());
            span.innerText = direction;
            dropdownFilterItem.appendChild(span);
            return dropdownFilterItem;
        };
        FilterMenu.prototype.dropdownFilterContent = function() {
            var _this = this;
            var self = this;
            var dropdownFilterContent = document.createElement(`div`);
            dropdownFilterContent.className = `dropdown-filter-content`;
            var innerDivs = this.tds.reduce(function(arr, el) {
                var values = arr.map(function(el) {
                    return el.innerText.trim();
                });
                if (values.indexOf(el.innerText.trim()) < 0) {arr.push(el);}
                return arr;
            }, []).sort(function(a, b) {
                var A = a.innerText.toLowerCase();
                var B = b.innerText.toLowerCase();
                if (!isNaN(Number(A)) && !isNaN(Number(B))) {
                    if (Number(A) < Number(B)) {return -1;}
                    if (Number(A) > Number(B)) {return 1;}
                } else {
                    if (A < B) {return -1;}
                    if (A > B) {return 1;}
                }
                return 0;
            }).map(function(td) {
                return _this.dropdownFilterItem(td, self);
            });
            this.inputs = innerDivs.map(function(div) {
                return div.firstElementChild;
            });
            var selectAllCheckboxDiv = this.dropdownFilterItemSelectAll();
            this.selectAllCheckbox = selectAllCheckboxDiv.firstElementChild;
            innerDivs.unshift(selectAllCheckboxDiv);
            var searchFilterDiv = this.dropdownFilterSearch();
            this.searchFilter = searchFilterDiv.firstElementChild;
            var outerDiv = innerDivs.reduce(function(outerDiv, innerDiv) {
                outerDiv.appendChild(innerDiv);
                return outerDiv;
            }, document.createElement(`div`));
            outerDiv.className = `checkbox-container`;
            var elements = [];
            if (this.options.sort) {elements = elements.concat([this.dropdownFilterSort(this.options.captions.a_to_z), this.dropdownFilterSort(this.options.captions.z_to_a)]);}
            if (this.options.search) {elements.push(searchFilterDiv);}
            return elements.concat(outerDiv).reduce(function(html, el) {
                html.appendChild(el);
                return html;
            }, dropdownFilterContent);
        };
        FilterMenu.prototype.dropdownFilterDropdown = function() {
            var dropdownFilterDropdown = document.createElement(`div`);
            dropdownFilterDropdown.className = `dropdown-filter-dropdown`;
            var arrow = document.createElement(`span`);
            arrow.className = `glyphicon glyphicon-arrow-down dropdown-filter-icon`;
            var icon = document.createElement(`i`);
            icon.className = `arrow-down`;
            arrow.appendChild(icon);
            dropdownFilterDropdown.appendChild(arrow);
            dropdownFilterDropdown.appendChild(this.dropdownFilterContent());
            if (jQuery(this.th).hasClass(`no-sort`)) {
                jQuery(dropdownFilterDropdown).find(`.dropdown-filter-sort`).remove();
            }
            if (jQuery(this.th).hasClass(`no-filter`)) {
                jQuery(dropdownFilterDropdown).find(`.checkbox-container`).remove();
            }
            if (jQuery(this.th).hasClass(`no-search`)) {
                jQuery(dropdownFilterDropdown).find(`.dropdown-filter-search`).remove();
            }
            return dropdownFilterDropdown;
        };
        return FilterMenu;
    }());

    var FilterCollection = (function() {
        function FilterCollection(target, options) {
            this.target = target;
            this.options = options;
            this.ths = target.find(`th.filter` + options.columnSelector).toArray();
            this.filterMenus = this.ths.map(function(th, index) {
                var column = jQuery(th).index();
                return new FilterMenu(target, th, column, index, options);
            });
            // 2023-07-11 son chg
            // this.rows = target.find(`tbody`).find(`tr`).toArray();
            this.rows = target.find(`> tbody`).find(`> tr`).toArray();
            this.table = target.get(0);
        }
        FilterCollection.prototype.initialize = function() {
            this.filterMenus.forEach(function(filterMenu) {
                filterMenu.initialize();
            });
            this.bindCheckboxes();
            this.bindSelectAllCheckboxes();
            this.bindSort();
            this.bindSearch();
        };
        FilterCollection.prototype.bindCheckboxes = function() {
            var filterMenus = this.filterMenus;
            var rows = this.rows;
            var ths = this.ths;
            var table = this.table;
            var updateRowVisibility = this.updateRowVisibility;
            this.target.find(`.dropdown-filter-menu-item.item`).change(function() {
                var index = jQuery(this).data(`index`);
                var value = jQuery(this).val();
                filterMenus[index].updateSelectAll();
                // 2023-07-24 son chg
                // updateRowVisibility(filterMenus, rows, ths);
                updateRowVisibility(filterMenus, rows, ths, table);
            });
        };
        FilterCollection.prototype.bindSelectAllCheckboxes = function() {
            var filterMenus = this.filterMenus;
            var rows = this.rows;
            var ths = this.ths;
            var table = this.table;
            var updateRowVisibility = this.updateRowVisibility;
            this.target.find(`.dropdown-filter-menu-item.select-all`).change(function() {
                var index = jQuery(this).data(`index`);
                var value = this.checked;
                filterMenus[index].selectAllUpdate(value);
                // 2023-07-24 son chg
                // updateRowVisibility(filterMenus, rows, ths);
                updateRowVisibility(filterMenus, rows, ths, table);
            });
        };
        FilterCollection.prototype.bindSort = function() {
            var filterMenus = this.filterMenus;
            var rows = this.rows;
            var ths = this.ths;
            var sort = this.sort;
            var table = this.table;
            var options = this.options;
            var updateRowVisibility = this.updateRowVisibility;
            this.target.find(`.dropdown-filter-sort`).click(function() {
                var $sortElement = jQuery(this).find(`span`);
                var column = $sortElement.data(`column`);
                var order = $sortElement.attr(`class`);
                sort(column, order, table, options);
                // 2023-07-24 son chg
                // updateRowVisibility(filterMenus, rows, ths);
                updateRowVisibility(filterMenus, rows, ths, table);
            });
        };
        FilterCollection.prototype.bindSearch = function() {
            var filterMenus = this.filterMenus;
            var rows = this.rows;
            var ths = this.ths;
            var table = this.table;
            var updateRowVisibility = this.updateRowVisibility;
            this.target.find(`.dropdown-filter-search`).keyup(function() {
                var $input = jQuery(this).find(`input`);
                var index = $input.data(`index`);
                var value = $input.val();
                filterMenus[index].searchToggle(value);
                // 2023-07-24 son chg
                // updateRowVisibility(filterMenus, rows, ths);
                updateRowVisibility(filterMenus, rows, ths, table);
            });
        };
        // FilterCollection.prototype.updateRowVisibility = function(filterMenus, rows, ths) {
        FilterCollection.prototype.updateRowVisibility = function(filterMenus, rows, ths, table) {
            // 2023-08-02 son chg
            var tbody = jQuery(table).find(`tbody`).get(0);
            var thead = jQuery(table).find(`thead`).get(0);
            var subtableRows = jQuery(tbody).find(`> tr.sheet-subtablerow`);

            if (subtableRows.length > 0) {
                jQuery(thead).find(`th[data-code="${jQuery(subtableRows[0]).find(`table`).data(`code`)}"]`).children(`a.open-subtable-btn`).text(`+`);
            }
            subtableRows.each(function(id, subtableRow) {
                // 2023-09-28 son chg
                // jQuery(subtableRow).find(`table`).hide();
                // jQuery(subtableRow).find(`table`).appendTo(jQuery(subtableRow).prev(`tr`).children(`td[data-code="${jQuery(subtableRow).find(`table`).data(`code`)}"]`));
                var $subtable = jQuery(subtableRow).find(`table`);
                jQuery(subtableRow).next(`tr`).children(`td`).removeClass(`tr-border-top`);
                $subtable.removeClass(`all-rows-showing`);
                $subtable.hide();
                $subtable.children(`tr`).hide();
                $subtable.appendTo(jQuery(subtableRow).prev(`tr`).children(`td[data-code="${$subtable.data(`code`)}"]`));
                jQuery(subtableRow).remove();
                jQuery(`div.hide`).toggleClass(`hide show`).text(`表示する`);
            });
            var showRows = rows;
            var hideRows = [];
            var selectedLists = filterMenus.map(function(filterMenu) {
                return {
                    column: filterMenu.column,
                    selected: filterMenu.inputs.filter(function(input) {
                        return input.checked;
                    }).map(function(input) {
                        return input.value.trim().replace(/ +(?= )/g, ``);
                    })
                };
            });

            for (var i = 0; i < rows.length; i++) {
                var tds = rows[i].children;
                for (var j = 0; j < selectedLists.length; j++) {
                    // 2023-04-19 saito chg
                    // var content = tds[selectedLists[j].column].innerText.trim().replace(/ +(?= )/g, '');
                    var content = jQuery(tds[selectedLists[j].column]).children(`.sheet-sort-value`).eq(0).text();
                    content = content.trim().replace(/ +(?= )/g, ``);
                    if (selectedLists[j].selected.indexOf(content) === -1) {
                        jQuery(rows[i]).hide();
                        break;
                    }
                    jQuery(rows[i]).show();
                }
            }
            var showingRows = [];
            var hiddingRows = [];
            rows.forEach(row => {
                if (jQuery(row).css(`display`) !== `none`) {
                    showingRows.push(row);
                } else {
                    hiddingRows.push(row);
                }
            });
            var supportedLanguages = [`ja`, `en`, `zh`, `es`];
            var userLang = kintone.getLoginUser().language;
            var lang = supportedLanguages.includes(userLang) ? userLang : `en`;

            var $pageDom = jQuery(`.component-app-listtable-countitem-page`);
            var $totalDom = jQuery(`.component-app-listtable-countitem-count`);

            if (showingRows.length !== 0 && hiddingRows.length !== 0) {
                var pageText = getPageIndex(lang, initialPageStr, showingRows.length);
                $pageDom.text(pageText);
                $totalDom.text(initialTotalStr.replace(/\d+/g, showingRows.length));
            } else if (showingRows.length === 0) {
                var zeroPageText = getZeroPage(lang);
                $pageDom.text(zeroPageText);
                $totalDom.text(initialTotalStr.replace(/\d+/g, showingRows.length));
            } else if (hiddingRows.length === 0) {
                $pageDom.text(initialPageStr);
                $totalDom.text(initialTotalStr);
            }
        };
        FilterCollection.prototype.sort = function(column, order, table, options) {
            var flip = 1;
            if (order === options.captions.z_to_a.toLowerCase().split(` `).join(`-`)) {flip = -1;}
            var tbody = jQuery(table).find(`tbody`).get(0);
            var thead = jQuery(table).find(`thead`).get(0);
            // 2023-08-02 son chg
            // var rows = jQuery(tbody).find(`tr`).get();
            var rows = jQuery(tbody).find(`> tr:not(.sheet-subtablerow)`).get();
            var subtableRows = jQuery(tbody).find(`> tr.sheet-subtablerow`);

            if (subtableRows.length > 0) {
                jQuery(thead).find(`th[data-code="${jQuery(subtableRows[0]).find(`table`).data(`code`)}"]`).children(`a.open-subtable-btn`).text(`+`);
            }
            subtableRows.each(function(id, subtableRow) {
                // 2023-09-28 son chg
                // jQuery(subtableRow).find(`table`).hide();
                // jQuery(subtableRow).find(`table`).appendTo(jQuery(subtableRow).prev(`tr`).children(`td[data-code="${jQuery(subtableRow).find(`table`).data(`code`)}"]`));
                var $subtable = jQuery(subtableRow).find(`table`);
                jQuery(subtableRow).next(`tr`).children(`td`).removeClass(`tr-border-top`);
                $subtable.removeClass(`all-rows-showing`);
                $subtable.hide();
                $subtable.children(`tr`).hide();
                $subtable.appendTo(jQuery(subtableRow).prev(`tr`).children(`td[data-code="${$subtable.data(`code`)}"]`));
                jQuery(subtableRow).remove();
                jQuery(`div.hide`).toggleClass(`hide show`).text(`表示する`);
            });
            rows.sort(function(a, b) {
                // 2023-06-02 saito chg
                // var A = a.children[column].innerText.toUpperCase();
                // var B = b.children[column].innerText.toUpperCase();
                var A = a.children[column].getElementsByClassName(`sheet-sort-value`)[0].innerText.toUpperCase();
                var B = b.children[column].getElementsByClassName(`sheet-sort-value`)[0].innerText.toUpperCase();
                if (!isNaN(Number(A)) && !isNaN(Number(B))) {
                    if (Number(A) < Number(B)) {return -1 * flip;}
                    if (Number(A) > Number(B)) {return Number(flip);}
                } else {
                    if (A < B) {return -1 * flip;}
                    if (A > B) {return Number(flip);}
                }
                return 0;
            });
            for (var i = 0; i < rows.length; i++) {
                tbody.appendChild(rows[i]);
            }
        };
        return FilterCollection;
    }());

    $$1.fn.excelTableFilter = function(options) {
        var target = this;
        options = $$1.extend({}, $$1.fn.excelTableFilter.options, options);
        if (typeof options.columnSelector === `undefined`) {options.columnSelector = ``;}
        if (typeof options.sort === `undefined`) {options.sort = true;}
        if (typeof options.search === `undefined`) {options.search = true;}
        if (typeof options.captions === `undefined`) {
            options.captions = {
                a_to_z: `昇順`,
                z_to_a: `降順`,
                search: `検索`,
                select_all: `すべて`
            };
        }
        var filterCollection = new FilterCollection(target, options);
        filterCollection.initialize();
        initialPageStr = jQuery(`.component-app-listtable-countitem-page`).first().text();
        initialTotalStr = jQuery(`.component-app-listtable-countitem-count`).first().text();
        getTotalCount().then(function(r) {
            initialTotalStr = initialTotalStr.replace(/\d+/g, r.totalCount);
            jQuery(`.component-app-listtable-countitem-count`).text(initialTotalStr);
        });
        return target;
    };
    $$1.fn.excelTableFilter.options = {};

    // エスケープ処理
    function escape_html(string) {
        if (typeof string !== `string`) {
            return string;
        }
        return string.replace(/[&'`"<>]/g, function(match) {
            return {
                '&': `&amp;`,
                "'": `&#39;`,
                '`': `&#x60;`,
                '"': `&quot;`,
                '<': `&lt;`,
                '>': `&gt;`
            }[match];
        });
    }

    function getPageIndex(lang, pageStr, endIndex) {
        var arr = pageStr.split(` `);
        arr.pop();
        var pageText = ``;
        switch (lang) {
            case `ja`:
                pageText = `1 - ${endIndex}`;
                break;
            case `en`:
                pageText = `Records 1 - ${endIndex}`;
                break;
            case `zh`:
                pageText = `显示1 - ${endIndex}`;
                break;
            default:
                pageText = `Records 1 - ${endIndex}`;
                break;
        }
        return pageText;
    }

    function getZeroPage(lang) {
        var pageText = ``;
        switch (lang) {
            case `ja`:
                pageText = `0 - 0`;
                break;
            case `en`:
                pageText = `Records 0 - 0`;
                break;
            case `zh`:
                pageText = `显示0 - 0`;
                break;
            default:
                pageText = `Records 0 - 0`;
                break;
        }
        return pageText;
    }

    // レコードの合計数を取得
    function getTotalCount() {
        const params = {
            app: kintone.app.getId(),
            totalCount: true,
            query: kintone.app.getQueryCondition()
        };
        return kintone.api(kintone.api.url(`/k/v1/records`, true), `GET`, params);
    }

}(jQuery));
// # sourceMappingURL=excel-bootstrap-table-filter-bundle.js.map
